### **Overview**

Cisco Secure Firewall Threat Defense uses the ASA engine for VPN functionalities (e.g., Layer 3-4 filtering, NAT, routing, VPNs). While the configuration objects are the same as on Cisco Secure Firewall ASA, the configuration steps via Cisco Secure Firewall Management Center differ.

---

### **Configuration Steps**

#### **1. Create a VPN Topology**

- Perform the following:
    - Specify a topology name.
    - Select a **policy-based (crypto map)** or **route-based (VTI)** VPN.
    - Choose a topology type:
        - Point-to-point, hub and spoke, or full mesh.
    - Enable IKEv1, IKEv2, or both.
    - Choose VPN endpoints:
        - For managed devices: Select the interface for VPN and the local network to protect.
        - For extranet devices: Specify IP address and protected networks.
    - Configure IKE authentication and IKE policy:
        - Specify encryption, integrity, PRF algorithms, and DH group.
        - Choose authentication type (e.g., PSK).
        - **Note**: Asymmetric IKEv2 authentication is not supported via the GUI.
    - Configure the IPsec proposal or transform set:
        - Defines IPsec (child) SA parameters (encryption, integrity algorithms).
    - Leave other settings at default for basic deployments.

---

#### **2. Configure NAT Exemption**

- Prevent VPN traffic from being translated by NAT rules:
    - Use **Manual NAT Configuration** in the first section of the NAT table.
    - Define:
        - **Original Packet**: Local protected network as the source and remote network as the destination.
        - **Translated Packet**: Set both source and destination to "Original."
        - Use **Static Translation** for bidirectional traffic.

---

#### **3. Allow VPN Traffic in the Access Control Policy (ACP)**

- VPN traffic is treated as regular traffic in Cisco Secure Firewall Threat Defense:
    - Explicitly allow VPN traffic in the ACP.
    - Ensure rules permit bidirectional traffic (local to remote and vice versa).
    - If no rules are configured, VPN traffic may match the default action (likely "drop all").

---

#### **4. Configure Routing**

- Enable the appliance to reach remote networks:
    - If VPN traffic terminates on the **outside interface** and a default route to the outside exists, no additional configuration is required.
    - For other interfaces (e.g., WAN or ISP-dedicated), configure a **specific static route** pointing to the VPN-enabled interface.

---

### **Verification and Troubleshooting**

#### **1. Verify ACP Rules**

- Confirm that VPN traffic is allowed by the ACP:
    - Use **Connection Events** in Cisco Secure Firewall Management Center.
    - Use **Packet Tracer** (via CLI or Management Center) to determine if traffic is being dropped by the ACP.

#### **2. Verify NAT**

- Ensure VPN traffic is not being translated:
    - Use `show nat` and `show xlate` commands from the Threat Defense CLI.
    - Use **Packet Tracer** to check NAT rules affecting VPN traffic.

#### **3. Verify Routing**

- Verify that a route exists for remote networks:
    - Use `show route` from the Threat Defense CLI to identify the egress interface.
    - Use **Packet Tracer** to confirm routing rules.

#### **4. Verify IKE Security Associations (SA)**

- Confirm IKE SA establishment:
    - Use `show crypto ikev2 sa` from the Threat Defense CLI.
    - If SA is not established, verify IKE authentication and parameters.

#### **5. Verify IPsec Security Associations (SA)**

- Check IPsec SAs and traffic encryption/decryption:
    - Use `show crypto ipsec sa` from the Threat Defense CLI.
    - If SAs are not established or traffic is not encrypted, review IPsec parameters.

---

### **Key Considerations**

- **NAT Configuration**: Misconfigured NAT can prevent VPN traffic from matching the crypto ACL, halting IKE exchanges.
- **Routing**: Incorrect routing may send traffic to the wrong interface or drop it entirely.
- **ACP Rules**: Ensure explicit rules for VPN traffic; no rules may result in dropped packets.